<?php

require_once get_template_directory() . '/vendor/autoload.php';

add_action('after_setup_theme', 'pyrene_load_carbon_fields');
function pyrene_load_carbon_fields()
{
    \Carbon_Fields\Carbon_Fields::boot();
}

if (!class_exists('\\Carbon_Fields\\Carbon_Fields')) {
    add_action('admin_notices', function () {
        echo '<div class="error"><p>Le thème Pyrene nécessite Carbon Fields pour fonctionner correctement. Veuillez installer les dépendances via Composer.</p></div>';
    });
}

function pyrene_theme_setup()
{
    add_theme_support('post-thumbnails');
    add_theme_support('editor-styles');
    add_theme_support('responsive-embeds');
    add_theme_support('align-wide');
    add_theme_support('custom-line-height');
    remove_theme_support('core-block-patterns');

    // Définir les tailles d'images personnalisées pour le carrousel hero
    add_image_size('hero-large', 1920, 1080, true);
    add_image_size('hero-medium', 1200, 675, true);
}
add_action('after_setup_theme', 'pyrene_theme_setup');


// Enregistrer les menus de navigation
function pyrene_register_menus()
{
    register_nav_menus([
        'primary' => 'Menu Principal',
        'footer'  => 'Menu Pied de Page',
    ]);
}
add_action('init', 'pyrene_register_menus');
