<?php
// Register Custom Post Type Portrait
function register_cpt_portrait() {
    $labels = array(
        'name' => 'Portraits',
        'singular_name' => 'Portrait',
        'menu_name' => 'Portraits',
        'name_admin_bar' => 'Portrait',
        'add_new' => 'Ajouter un portrait',
        'add_new_item' => 'Ajouter un nouveau portrait',
        'new_item' => 'Nouveau portrait',
        'edit_item' => 'Modifier le portrait',
        'view_item' => 'Voir le portrait',
        'all_items' => 'Tous les portraits',
        'search_items' => 'Rechercher des portraits',
        'not_found' => 'Aucun portrait trouvé',
    );

    $args = array(
        'labels' => $labels,
        'public' => true,
        'show_in_rest' => true,
        'has_archive' => true,
        'menu_position' => 5,
        'menu_icon' => 'dashicons-id',
        'supports' => array('title', 'editor', 'excerpt', 'thumbnail', 'author', 'revisions'),
        'taxonomies' => array('category', 'post_tag'),
        'rewrite' => array('slug' => 'portrait'),
        'show_in_nav_menus' => true,
    );

    register_post_type('portrait', $args);
}
add_action('init', 'register_cpt_portrait');
