<?php

use Carbon_Fields\Container;
use Carbon_Fields\Field;

/**
 * Register Custom Post Type 'magazine' with Carbon Fields
 *
 * @package Pyrene
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}


/**
 * Register Magazine CPT
 */
function pyrene_register_magazine_cpt()
{
    $labels = array(
        'name'                  => _x('Magazines', 'Post type general name', 'pyrene'),
        'singular_name'         => _x('Magazine', 'Post type singular name', 'pyrene'),
        'menu_name'             => _x('Magazines', 'Admin Menu text', 'pyrene'),
        'name_admin_bar'        => _x('Magazine', 'Add New on Toolbar', 'pyrene'),
        'add_new'               => __('Ajouter', 'pyrene'),
        'add_new_item'          => __('Ajouter un nouveau magazine', 'pyrene'),
        'new_item'              => __('Nouveau magazine', 'pyrene'),
        'edit_item'             => __('Modifier le magazine', 'pyrene'),
        'view_item'             => __('Voir le magazine', 'pyrene'),
        'all_items'             => __('Tous les magazines', 'pyrene'),
        'search_items'          => __('Rechercher des magazines', 'pyrene'),
        'parent_item_colon'     => __('Magazine parent :', 'pyrene'),
        'not_found'             => __('Aucun magazine trouvé.', 'pyrene'),
        'not_found_in_trash'    => __('Aucun magazine trouvé dans la corbeille.', 'pyrene'),
        'featured_image'        => __('Image de couverture', 'pyrene'),
        'set_featured_image'    => __('Définir l\'image de couverture', 'pyrene'),
        'remove_featured_image' => __('Supprimer l\'image de couverture', 'pyrene'),
        'use_featured_image'    => __('Utiliser comme image de couverture', 'pyrene'),
        'archives'              => __('Archives des magazines', 'pyrene'),
        'insert_into_item'      => __('Insérer dans le magazine', 'pyrene'),
        'uploaded_to_this_item' => __('Téléversé pour ce magazine', 'pyrene'),
        'filter_items_list'     => __('Filtrer la liste des magazines', 'pyrene'),
        'items_list_navigation' => __('Navigation de la liste des magazines', 'pyrene'),
        'items_list'            => __('Liste des magazines', 'pyrene'),
    );

    $args = array(
        'labels'                => $labels,
        'public'                => true,
        'publicly_queryable'    => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'query_var'             => true,
        'rewrite'               => array('slug' => 'magazine'),
        'capability_type'       => 'post',
        'has_archive'           => true,
        'hierarchical'          => false,
        'menu_position'         => 5,
        'menu_icon'             => 'dashicons-book',
        'supports'              => array('title', 'thumbnail', 'excerpt'),
        'show_in_rest'          => true,
    );

    register_post_type('magazine', $args);
}
add_action('init', 'pyrene_register_magazine_cpt');

/**
 * Register Magazine Tags
 */
function pyrene_register_magazine_tags()
{
    $labels = array(
        'name'                       => _x('Étiquettes de Magazine', 'taxonomy general name', 'pyrene'),
        'singular_name'              => _x('Étiquette de Magazine', 'taxonomy singular name', 'pyrene'),
        'search_items'               => __('Rechercher des étiquettes', 'pyrene'),
        'popular_items'              => __('Étiquettes populaires', 'pyrene'),
        'all_items'                  => __('Toutes les étiquettes', 'pyrene'),
        'parent_item'                => null,
        'parent_item_colon'          => null,
        'edit_item'                  => __('Modifier l\'étiquette', 'pyrene'),
        'update_item'                => __('Mettre à jour l\'étiquette', 'pyrene'),
        'add_new_item'               => __('Ajouter une nouvelle étiquette', 'pyrene'),
        'new_item_name'              => __('Nom de la nouvelle étiquette', 'pyrene'),
        'separate_items_with_commas' => __('Séparer les étiquettes par des virgules', 'pyrene'),
        'add_or_remove_items'        => __('Ajouter ou supprimer des étiquettes', 'pyrene'),
        'choose_from_most_used'      => __('Choisir parmi les plus utilisées', 'pyrene'),
        'menu_name'                  => __('Étiquettes', 'pyrene'),
    );

    $args = array(
        'hierarchical'      => false,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'magazine-tag'),
        'show_in_rest'      => true,
    );

    register_taxonomy('magazine_tag', 'magazine', $args);
}
add_action('init', 'pyrene_register_magazine_tags');

/**
 * Register Carbon Fields for Magazine CPT
 */
add_action('carbon_fields_register_fields', 'pyrene_register_carbon_fields');
function pyrene_register_carbon_fields()
{
    Container::make('post_meta', __('Détails du magazine', 'pyrene'))
        ->where('post_type', '=', 'magazine')
        ->add_fields(array(
            Field::make('text', 'magazine_numero', __('Numéro:', 'pyrene'))
                ->set_help_text(__('Numéro de l\'édition du magazine', 'pyrene')),

            Field::make('date', 'magazine_date', __('Date de publication:', 'pyrene'))
                ->set_attribute('placeholder', 'Sélectionner une date')
                ->set_storage_format('Y-m-d')
                ->set_help_text(__('Date de publication du magazine', 'pyrene')),
            Field::make('text', 'to_buy_link', __('Lien d\'achat:', 'pyrene'))
                ->set_help_text(__('URL vers la plateforme d\'achat du magazine', 'pyrene'))
                ->set_attribute('placeholder', 'https://...')
        ));
}

/**
 * Compatibilité des champs pour les requêtes REST API et WP_Query
 */
function pyrene_register_carbon_fields_compatibility()
{
    // Permettre de filtrer par carbon field dans WP_Query et REST API
    add_filter('carbon_fields_should_save_field_value', function ($save, $value, $field) {
        // Ajouter la compatibilité pour nos champs spécifiques
        $fieldName = $field->get_base_name();
        if (in_array($fieldName, ['magazine_numero', 'magazine_date', 'magazine_a_la_une'])) {
            update_post_meta(get_the_ID(), $fieldName, $value);
        }
        return $save;
    }, 10, 3);
}
add_action('init', 'pyrene_register_carbon_fields_compatibility');
