<?php

// Register custom pattern categories named 'Compositions pour Pyrenées Magazine'
function pyrene_register_custom_pattern_categories()
{
    register_block_pattern_category(
        'pyrene-patterns',
        array(
            'label' => __('Compositions pour Pyrenées Magazine', 'pyrene'),
        )
    );
    // Create an other caterogy for build articles
    register_block_pattern_category(
        'pyrene-articles',
        array(
            'label' => __('Compositions pour les articles', 'pyrene'),
        )
    );
}

add_action('init', 'pyrene_register_custom_pattern_categories');


function pyrene_register_patterns()
{
    register_block_pattern(
        'pyrene/equipe',
        array(
            'title' => __('Équipe', 'pyrene'),
            'description' => __('Composition pour afficher l\'équipe', 'pyrene'),
            'categories' => array('pyrene-patterns'),
            'content' => file_get_contents(get_template_directory() . '/patterns/equipe.php'),
        )
    );
    register_block_pattern(
        'pyrene/6-articles-pagines',
        array(
            'title' => __('6 articles paginés', 'pyrene'),
            'description' => __('6 articles paginés', 'pyrene'),
            'categories' => array('pyrene-patterns'),
            'content' => file_get_contents(get_template_directory() . '/patterns/6-articles-pagines.php'),
        )
    );
    register_block_pattern(
        'pyrene/article-a-la-une',
        array(
            'title' => __('Retrouvez nos derniers articles', 'pyrene'),
            'description' => __('Retrouvez nos derniers articles', 'pyrene'),
            'categories' => array('pyrene-patterns'),
            'content' => file_get_contents(get_template_directory() . '/patterns/articles-a-la-une.php'),
        )
    );
    register_block_pattern(
        'pyrene/community',
        array(
            'title' => __('Communauté', 'pyrene'),
            'description' => __('Communauté', 'pyrene'),
            'categories' => array('pyrene-patterns'),
            'content' => file_get_contents(get_template_directory() . '/patterns/community.php'),
        )
    );
    register_block_pattern(
        'pyrene/lieux-et-randos',
        array(
            'title' => __('Lieux et randos', 'pyrene'),
            'description' => __('Lieux et randos', 'pyrene'),
            'categories' => array('pyrene-patterns'),
            'content' => file_get_contents(get_template_directory() . '/patterns/lieux-et-randos.php'),
        )
    );
    register_block_pattern(
        'pyrene/magazines',
        array(
            'title' => __(' Section Magazines', 'pyrene'),
            'description' => __(' Section Magazines', 'pyrene'),
            'categories' => array('pyrene-patterns'),
            'content' => file_get_contents(get_template_directory() . '/patterns/magazines.php'),
        )
    );
    register_block_pattern(
        'pyrene/newsletter',
        array(
            'title' => __('Newsletter', 'pyrene'),
            'description' => __('Newsletter', 'pyrene'),
            'categories' => array('pyrene-patterns'),
            'content' => file_get_contents(get_template_directory() . '/patterns/newsletter.php'),
        )
    );
    register_block_pattern(
        'pyrene/texte-et-image',
        array(
            'title' => __('Texte et image', 'pyrene'),
            'description' => __('Texte et image', 'pyrene'),
            'categories' => array('pyrene-articles'),
            'content' => file_get_contents(get_template_directory() . '/patterns/texte-et-image.php'),
        )
    );
    register_block_pattern(
        'pyrene/titre-et-sous-titre-2',
        array(
            'title' => __('Titre et sous titre - Version 2', 'pyrene'),
            'description' => __('Titre et sous titre - Version 2', 'pyrene'),
            'categories' => array('pyrene-articles', 'pyrene-patterns'),
            'content' => file_get_contents(get_template_directory() . '/patterns/titre-et-sous-titre-2.php'),
        )
    );
    register_block_pattern(
        'pyrene/titre-et-sous-titre',
        array(
            'title' => __('Titre et sous titre', 'pyrene'),
            'description' => __('Titre et sous titre', 'pyrene'),
            'categories' => array('pyrene-articles', 'pyrene-patterns'),
            'content' => file_get_contents(get_template_directory() . '/patterns/titre-et-sous-titre.php'),
        )
    );
    register_block_pattern(
        'pyrene/titre-sous-titre-description-et-contenu',
        array(
            'title' => __('Titre, sous titre, description et contenu', 'pyrene'),
            'description' => __('Titre, sous titre, description et contenu', 'pyrene'),
            'categories' => array('pyrene-articles'),
            'content' => file_get_contents(get_template_directory() . '/patterns/titre-sous-titre-description-et-contenu.php'),
        )
    );
    register_block_pattern(
        'pyrene/valleys',
        array(
            'title' => __('Nos vallées sont vivantes', 'pyrene'),
            'description' => __('Nos vallées sont vivantes', 'pyrene'),
            'categories' => array('pyrene-patterns'),
            'content' => file_get_contents(get_template_directory() . '/patterns/valleys.php'),
        )
    );

}
add_action('init', 'pyrene_register_patterns');