<?php

use Carbon_Fields\Container;
use Carbon_Fields\Field;

Container::make('post_meta', 'Informations randonnée')
    ->where('post_type', '=', 'randonnee')
    ->add_fields([
        Field::make('text', 'subtitle', 'Sous-titre'),
        Field::make('select', 'difficulty', 'Difficulté')
            ->add_options([
                'facile' => 'Facile',
                'moyenne' => 'Moyenne',
                'difficile' => 'Difficile',
            ]),
        Field::make('text', 'duration', 'Durée')->set_help_text('ex : 3h30'),
        Field::make('text', 'distance', 'Distance')->set_help_text('ex : 10 km'),
        Field::make('text', 'elevation_gain', 'Dénivelé positif')->set_help_text('ex : 500 m'),
        Field::make('text', 'photo_credit', 'Crédit photo'),
    ]);
