<?php
// Déterminer l'environnement actuel
$current_env = getenv('WP_ENV');

// Si la variable d'environnement n'est pas définie, détecter automatiquement
if (!$current_env) {
    $host = $_SERVER['HTTP_HOST'] ?? '';
    
    if (strpos($host, 'pyrenees-magazine.local') !== false) {
        $current_env = 'local';
    } elseif (strpos($host, 'ouzom.fr') !== false) {
        $current_env = 'staging';
    } elseif (strpos($host, 'pyreneesmagazine.com') !== false) {
        $current_env = 'production';
    } else {
        // Environnement par défaut si aucune correspondance
        $current_env = 'production';
    }
}

// Chemin vers le fichier de configuration spécifique à l'environnement
$config_file = dirname(__FILE__) . "/config.{$current_env}.php";

// Vérifier si le fichier existe
if (file_exists($config_file)) {
    require_once $config_file;
} else {
    // Fallback sur la configuration de production si le fichier spécifique n'existe pas
    $fallback_file = dirname(__FILE__) . "/config.production.php";
    
    if (file_exists($fallback_file)) {
        require_once $fallback_file;
        // Optionnel: Journaliser un avertissement
        if (defined('WP_DEBUG') && WP_DEBUG) {
            error_log("Configuration pour l'environnement '{$current_env}' non trouvée, utilisation de la production comme fallback.");
        }
    } else {
        // Arrêter l'exécution si aucun fichier de configuration n'est trouvé
        wp_die("Erreur critique: Aucun fichier de configuration trouvé. Veuillez configurer le thème correctement.");
    }
}