<?php

/**
 * Créer une variable globale pour les informations utilisateur
 * Cette fonction sera exécutée au début de chaque chargement de page
 */
function init_user_auth() {
    global $current_user_data;
    
    // Vérifier si l'utilisateur est connecté via le cookie
    $current_user_data = is_user_logged_in_via_cookie(ENCRYPTION_KEY);
}
add_action('init', 'init_user_auth');


/**
 * Vérifie si l'utilisateur est connecté
 *
 * @return bool True si l'utilisateur est connecté, false sinon
 */
function is_user_logged_in_by_cookie() {
    global $current_user_data;
    return $current_user_data !== false;
}

/**
 * Récupère les données de l'utilisateur connecté
 *
 * @return array|false Données de l'utilisateur ou false si non connecté
 */
function get_current_user_data() {
    global $current_user_data;
    return $current_user_data;
}

/**
 * Vérifie si l'utilisateur a un abonnement actif pour un titre spécifique
 *
 * @param string $title_code Code du titre à vérifier
 * @return bool True si l'utilisateur a un abonnement actif, false sinon
 */
function user_has_subscription($title_code) {
    global $current_user_data;
    return has_active_subscription($current_user_data, $title_code);
}

/**
 * Récupère tous les abonnements actifs de l'utilisateur
 *
 * @return array Liste des codes de titres actifs
 */
function get_user_subscriptions() {
    global $current_user_data;
    return get_active_subscriptions($current_user_data);
}

/**
 * Génère l'URL vers la page d'authentification externe
 *
 * @param string $redirect_url URL de redirection après authentification (par défaut: '/')
 * @return string URL complète
 */
function get_auth_url($redirect_url = '/') {
    // Construire l'URL complète avec le domaine actuel comme URL de redirection
    $site_url = home_url($redirect_url);
    return get_external_auth_url(EXTERNAL_AUTH_URL, $site_url);
}