
<?php

require_once get_template_directory() . '/inc/setup.php';
require_once get_template_directory() . '/inc/calendar-news.php';
require_once get_template_directory() . '/inc/auth/config.php';

function pyrene_setup()
{
    add_theme_support('wp-block-styles');
}
add_action('after_setup_theme', 'pyrene_setup');


/**
 * Enqueue scripts and styles.
 */
function pyrene_enqueue_styles()
{
    // Enqueue main stylesheet compilé à partir de Sass
    wp_enqueue_style(
        'pyrene-main-style',
        get_template_directory_uri() . '/assets/css/main.css',
        array(),
        filemtime(get_template_directory() . '/assets/css/main.css')
    );
}
add_action('wp_enqueue_scripts', 'pyrene_enqueue_styles');

function pyrene_enqueue_scripts()
{
    // Enregistrement du JavaScript du carousel
    wp_enqueue_script(
        'pyrene-carousel',
        get_template_directory_uri() . '/assets/js/carousel.js',
        array(),
        filemtime(get_template_directory() . '/assets/js/carousel.js'),
        true
    );
    wp_enqueue_script(
        'pyrene-search',
        get_template_directory_uri() . '/assets/js/search.js',
        array(),
        filemtime(get_template_directory() . '/assets/js/search.js'),
        true
    );

    wp_enqueue_script(
        'pyrene-cookie-consent',
        get_template_directory_uri() . '/assets/js/cookie-consent.js',
        array(),
        filemtime(get_template_directory() . '/assets/js/cookie-consent.js'),
        true
    );
}
add_action('wp_enqueue_scripts', 'pyrene_enqueue_scripts');

add_filter('get_the_archive_title', function ($title) {
    if (is_post_type_archive('magazine')) {
        return 'Catalogue';
    }
    return $title;
});
add_filter('render_block', 'pyrene_replace_read_more_link_with_buy_button', 10, 2);
function pyrene_replace_read_more_link_with_buy_button($block_content, $block)
{
    if (
        is_post_type_archive('magazine') &&
        $block['blockName'] === 'core/post-excerpt'
    ) {
        global $post;

        $buy_link = carbon_get_post_meta($post->ID, 'to_buy_link');
        if ($buy_link) {
            // On cherche le lien "Lire la suite"
            $pattern = '/<a[^>]*href=["\'].*?["\'][^>]*>.*?Lire la suite.*?<\/a>/i';
            $replacement = '<a class="btn-buy" href="' . esc_url($buy_link) . '" target="_blank" rel="noopener noreferrer">Acheter</a>';

            // Remplace uniquement le lien "Lire la suite" par ton bouton
            return preg_replace($pattern, $replacement, $block_content);
        }
    }

    return $block_content;
}


function pyrene_register_blocks()
{
    register_block_type(get_template_directory() . '/blocks/magazines');
    register_block_type(get_template_directory() . '/blocks/hero-carousel');
    register_block_type(get_template_directory() . '/blocks/hero');
    register_block_type(get_template_directory() . '/blocks/hero-article');
    register_block_type(get_template_directory() . '/blocks/hero-hike');
    register_block_type(get_template_directory() . '/blocks/hero-hikes');
    register_block_type(get_template_directory() . '/blocks/hero-portrait');
    register_block_type(get_template_directory() . '/blocks/calendar-news');
    register_block_type(get_template_directory() . '/blocks/hero-magazine');
}
add_action('init', 'pyrene_register_blocks');


require_once get_template_directory() . '/blocks/hero-carousel/fields.php';
require_once get_template_directory() . '/blocks/hero/fields.php';
require_once get_template_directory() . '/blocks/hero-article/fields.php';
require_once get_template_directory() . '/blocks/hero-hike/fields.php';
require_once get_template_directory() . '/blocks/hero-hikes/fields.php';
require_once get_template_directory() . '/blocks/hero-portrait/fields.php';
require_once get_template_directory() . '/blocks/hero-magazine/fields.php';
require_once get_template_directory() . '/blocks/calendar-news/fields.php';

// Include Custom Post Types
require_once get_template_directory() . '/inc/post-types/cpt-magazine.php';
require_once get_template_directory() . '/inc/post-types/cpt-hike.php';
require_once get_template_directory() . '/inc/post-types/cpt-portrait.php';


add_action('carbon_fields_register_fields', function () {
    require_once get_template_directory() . '/inc/carbon-fields/hike-fields.php';
    require_once get_template_directory() . '/inc/carbon-fields/subscription.php';
    require_once get_template_directory() . '/inc/carbon-fields/news.php';
});


// Account functions

require_once get_template_directory() . '/inc/auth/functions.php';
require_once get_template_directory() . '/inc/account.php';
require_once get_template_directory() . '/inc/auth/premium-filter.php';

function pyrene_add_premium_marker_to_query_loop($block_content, $block)
{
    // Vérifier si nous avons affaire à un bloc post-template
    if ($block['blockName'] === 'core/post-template') {
        // Extraire les IDs des articles du contenu
        preg_match_all('/post-(\d+)/', $block_content, $matches);

        if (!empty($matches[1])) {
            foreach ($matches[1] as $post_id) {
                // Vérifier si l'article est premium
                if (function_exists('carbon_get_post_meta') && carbon_get_post_meta($post_id, 'is_premium_content')) {
                    // Ajouter la classe is-premium-content au li correspondant
                    $block_content = str_replace(
                        'class="wp-block-post post-' . $post_id,
                        'class="wp-block-post post-' . $post_id . ' is-premium-content',
                        $block_content
                    );
                }
            }
        }
    }

    return $block_content;
}
add_filter('render_block', 'pyrene_add_premium_marker_to_query_loop', 10, 2);

//Patterns
require_once get_template_directory() . '/inc/patterns.php';

// Analytics
require_once get_template_directory() . '/inc/analytics.php';