<?php
/**
 * Système de chargement des blocs personnalisés
 */

// Vérifier si Carbon Fields est activé
if (!function_exists('carbon_fields_boot_plugin')) {
    add_action('admin_notices', function() {
        echo '<div class="error"><p>Le thème Pyrene nécessite le plugin Carbon Fields pour fonctionner correctement.</p></div>';
    });
    return;
}

// Fonction pour charger tous les blocs
function pyrene_load_blocks() {
    $blocks_dir = get_template_directory() . '/blocks';
    $blocks = glob($blocks_dir . '/*/block.php');
    
    foreach ($blocks as $block) {
        require_once $block;
    }
}

// Charger les blocs après l'initialisation de Carbon Fields
add_action('carbon_fields_register_fields', 'pyrene_load_blocks');

// Enregistrer les catégories de blocs personnalisés
add_filter('block_categories_all', function($categories) {
    return array_merge(
        $categories,
        [
            [
                'slug'  => 'pyrene',
                'title' => 'Pyrene',
                'icon'  => null,
            ],
        ]
    );
});