<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

$image = $fields['image'] ?? '';
$title = $fields['title'] ?? '';
$subtitle = $fields['subtitle'] ?? '';
$tags = $fields['tags'] ?? '';
$author_credit = $fields['author_credit'] ?? '';

$image_url = wp_get_attachment_image_url($image, 'full');
$image_alt = get_post_meta($image, '_wp_attachment_image_alt', true);
?>

<section class="hero-banner">
    <article class="hero-banner__container">
        <div class="hero-banner__image-container">
            <img class="hero-banner__image"
                src="<?php echo esc_url($image_url); ?>"
                alt="<?php echo esc_attr($image_alt); ?>"
                loading="eager">
        </div>
        <div class="hero-banner__content">
            <h1 class="hero-banner__title has-white-color"><?= esc_html($title); ?></h1>

            <?php if (!empty($subtitle)) : ?>
                <p class="hero-banner__subtitle"><?= esc_html($subtitle); ?></p>
            <?php endif; ?>

            <?php if (!empty($tags)) : ?>
                <p class="hero-banner__tags"><?= esc_html($tags); ?></p>
            <?php endif; ?>


            <?php if (!empty($author_credit)) : ?>
                <p class="hero-banner__author-credit has-white-color"><?= esc_html($author_credit); ?></p>
            <?php endif; ?>
        </div>
    </article>
</section>
