<?php

use Carbon_Fields\Block;
use Carbon_Fields\Field;

function pyrene_register_hero_block_fields() {
    Block::make(__('Bannière Hero', 'pyrene'))
        ->add_fields([
            Field::make('image', 'image', __('Image de fond', 'pyrene')),

            Field::make('text', 'title', __('Titre', 'pyrene')),
            Field::make('text', 'subtitle', __('Sous-titre', 'pyrene')),
            Field::make('text', 'tags', __('Tags', 'pyrene')),
            Field::make('text', 'author_credit', __('Crédit de l\'image', 'pyrene'))
                ->set_help_text(__('Crédit de l\'image, par exemple: "©Jc_MIlhet"', 'pyrene')),
        ])
        ->set_mode('preview')
        ->set_render_callback(function ($fields, $attributes, $inner_blocks) {
            include_once dirname(__FILE__) . '/render.php';
        });
}

add_action('carbon_fields_register_fields', 'pyrene_register_hero_block_fields');