<?php
if (!defined('ABSPATH')) {
    exit;
}

$post_id = get_the_ID();
$title = get_the_title($post_id);
$buy_link = carbon_get_post_meta($post_id, 'to_buy_link');

// Image statique
$image_url = get_template_directory_uri() . '/assets/images/default-hero.png';
$image_alt = 'Image de fond du magazine';
?>

<section class="hero-hike" style="height: 70vh; max-height: none;">
    <article class="hero-hike__container">
        <div class="hero-hike__image-container">
            <img
                class="hero-hike__image"
                src="<?php echo esc_url($image_url); ?>"
                alt="<?php echo esc_attr($image_alt); ?>"
                loading="eager" />
        </div>

        <div class="hero-hike__content">
            <h1 class="hero-hike__title has-white-color"><?php echo esc_html($title); ?></h1>

            <?php if ($buy_link): ?>
                <a href="<?php echo esc_url($buy_link); ?>" class="btn-buy" target="_blank" rel="noopener noreferrer">
                    Acheter ce numéro
                </a>
            <?php endif; ?>
        </div>
    </article>
</section>
