<?php
if (!defined('ABSPATH'))
  exit;

$image_url = get_template_directory_uri() . '/assets/images/hero_randos.webp';
$logo_url = get_template_directory_uri() . '/assets/images/logo_randos.webp';
$author_img_url = get_template_directory_uri() . '/assets/images/cathala.webp';
?>

<section class="hero-hikes">
  <article class="hero-hikes__container">
    <div class="hero-hikes__image-container">
      <img class="hero-hikes__image" src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($image_alt); ?>"
        loading="eager">
    </div>
    <div class="hero-hikes__content">
      <img src="<?php echo esc_url($logo_url); ?>" alt="Logo Randos" class="hero-hikes__logo" />
      <figure class="wp-block-image aligncenter size-full">
        <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/white_map.png'); ?>"
          alt="Carte des randonnées" style="aspect-ratio:1.5;object-fit:contain" />
      </figure>
      <div class="hero-hikes__credit">
        <img src="<?php echo esc_url($author_img_url); ?>" alt="Cathala" class="hero-hikes__credit-img" />
        <span class="hero-hikes__credit-text">CRÉDIT PHOTO : J CATHALA - BENAT</span>
      </div>
    </div>
  </article>
</section>