<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

$post_id = $block->context['postId'] ?? get_the_ID();
$post = get_post($post_id);

if (!$post) {
    return;
}

// Get post meta
$title = get_the_title($post_id);
$categories = get_the_category($post_id);
$subtitle = carbon_get_post_meta($post_id, 'subtitle');
$difficulty = carbon_get_post_meta($post_id, 'difficulty');
$duration = carbon_get_post_meta($post_id, 'duration');
$distance = carbon_get_post_meta($post_id, 'distance');
$elevation_gain = carbon_get_post_meta($post_id, 'elevation_gain');
$photo_credit = carbon_get_post_meta($post_id, 'photo_credit');

// Get featured image
$image_id = get_post_thumbnail_id($post_id);
$image_url = wp_get_attachment_image_url($image_id, 'full');
$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true) ?: $title;

// Carte
$map_image = get_template_directory_uri() . '/assets/images/en_rando.png';

// Botte
$difficulty_map = ['facile' => 1, 'moyenne' => 2, 'difficile' => 3];
$boot_count = $difficulty_map[$difficulty] ?? 0;
$boot_img = get_template_directory_uri() . '/assets/images/hike_difficulty.png';

// Navigation
$prev_post = get_previous_post();
$next_post = get_next_post();
?>

<section class="hero-hike">
    <article class="hero-hike__container">
        <div class="hero-hike__image-container">
            <?php if ($image_url): ?>
                <img class="hero-hike__image" src="<?php echo esc_url($image_url); ?>"
                    alt="<?php echo esc_attr($image_alt); ?>" loading="eager" />
            <?php endif; ?>
        </div>

        <div class="hero-hike__content">

            <div class="hero-hike__infos">
                <?php if (!empty($categories)): ?>
                    <div class="hero-hike__categories">
                        <?php foreach ($categories as $category): ?>
                            <a href="<?php echo esc_url(get_category_link($category->term_id)); ?>" class="hero-hike__category">
                                <?php echo esc_html($category->name); ?>
                            </a>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>

                <?php if ($boot_count): ?>
                    <div class="hero-hike__difficulty">
                        <?php for ($i = 0; $i < $boot_count; $i++): ?>
                            <img src="<?php echo esc_url($boot_img); ?>" alt="Difficulté" class="hero-hike__boot" />
                        <?php endfor; ?>
                    </div>
                <?php endif; ?>
            </div>

            <h1 class="hero-hike__title has-white-color"><?php echo esc_html($title); ?></h1>
            <?php if ($subtitle): ?>
                <h2 class="hero-hike__subtitle"><?php echo esc_html($subtitle); ?></h2>
            <?php endif; ?>

            <figure class="wp-block-image aligncenter size-full">
                <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/white_map.png'); ?>"
                    alt="Carte des randonnées" style="aspect-ratio:1.5;object-fit:contain" />
            </figure>

            <div class="hero-hike__bottom">
                <div class="hero-hike__meta">
                    <?php if ($duration): ?>
                        <span>Durée : <?php echo esc_html($duration); ?></span>
                    <?php endif; ?>
                    <?php if ($distance): ?>
                        <span>/ Distance : <?php echo esc_html($distance); ?></span>
                    <?php endif; ?>
                    <?php if ($elevation_gain): ?>
                        <span>/ Dénivelé : <?php echo esc_html($elevation_gain); ?></span>
                    <?php endif; ?>
                </div>

                <?php if ($photo_credit): ?>
                    <div class="hero-hike__credit">
                        <strong>Crédit photo : <?php echo esc_html($photo_credit); ?></strong>
                    </div>
                <?php endif; ?>
            </div>

        </div>

        <!-- Navigation entre randonnées -->
        <div class="hero-hike__navigation">
            <?php if ($prev_post): ?>
                <a href="<?php echo esc_url(get_permalink($prev_post->ID)); ?>" class="hero-hike__nav hero-hike__nav--prev"
                    aria-label="Randonnée précédente : <?php echo esc_attr($prev_post->post_title); ?>">
                    <svg class="hero-hike__nav-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                        aria-hidden="true" focusable="false">
                        <path fill="none" stroke="currentColor" stroke-width="2" d="M15 6l-6 6 6 6" />
                    </svg>
                    <span
                        class="hero-hike__nav-title screen-reader-text"><?php echo esc_html($prev_post->post_title); ?></span>
                </a>
            <?php endif; ?>

            <?php if ($next_post): ?>
                <a href="<?php echo esc_url(get_permalink($next_post->ID)); ?>" class="hero-hike__nav hero-hike__nav--next"
                    aria-label="Randonnée suivante : <?php echo esc_attr($next_post->post_title); ?>">
                    <svg class="hero-hike__nav-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                        aria-hidden="true" focusable="false">
                        <path fill="none" stroke="currentColor" stroke-width="2" d="M9 6l6 6-6 6" />
                    </svg>
                    <span
                        class="hero-hike__nav-title screen-reader-text"><?php echo esc_html($next_post->post_title); ?></span>
                </a>
            <?php endif; ?>
        </div>
    </article>
</section>