<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}


// Get carbon fields values
$slides = $fields['slides'] ?? [];
$count = count($slides);
ob_start();
?>

<section class="hero">
    <div class="hero__carousel" aria-label="Carousel de présentation de Pyrénées Magazine">
        <?php foreach ($slides as $index => $slide):
            $image_url = wp_get_attachment_image_url($slide['image'], 'full');
            $image_alt = get_post_meta($slide['image'], '_wp_attachment_image_alt', true);
            $active_class = $index === 0 ? ' hero__slide--active' : '';
            ?>
            <article class="hero__slide<?php echo $active_class; ?>" id="hero-slide-<?php echo $index; ?>"
                aria-hidden="<?php echo $index === 0 ? 'false' : 'true'; ?>"
                aria-labelledby="hero-slide-title-<?php echo $index; ?>">
                <div class="hero__image-container">
                    <img class="hero__image" src="<?php echo esc_url($image_url); ?>"
                        alt="<?php echo esc_attr($image_alt); ?>" loading="<?php echo $index === 0 ? 'eager' : 'lazy'; ?>">
                </div>
                <div class="hero__content">
                    <?php if (!empty($slide['intro'])): ?>
                        <p class="hero__intro"><?= ($slide['intro']); ?></p>
                    <?php endif; ?>

                    <h1 class="hero__title has-white-color" id="hero-slide-title-<?= $index; ?>">
                        <?= esc_html($slide['title']); ?>
                    </h1>

                    <?php if (!empty($slide['subtitle'])): ?>
                        <p class="hero__subtitle"><?= esc_html($slide['subtitle']); ?></p>
                    <?php endif; ?>

                    <div class="hero__buttons">
                        <a href="<?= esc_url($slide['first_button_url']); ?>"
                            class="wp-block-button__link has-white-color has-primary-background-color has-text-color has-background has-link-color wp-element-button">
                            <?= esc_html($slide['first_button_text']); ?>
                        </a>

                        <?php if (!empty($slide['second_button_text']) && !empty($slide['second_button_url'])): ?>
                            <a href="<?= esc_url($slide['second_button_url']); ?>"
                                class="wp-block-button__link has-white-color has-primary-background-color has-text-color has-background has-link-color wp-element-button">
                                <?= esc_html($slide['second_button_text']); ?>
                            </a>
                        <?php endif; ?>
                    </div>

                    <?php if (!empty($slide['author_credit'])): ?>
                        <p class="hero__author-credit has-white-color open-sans-large-bold">
                            <?= esc_html($slide['author_credit']); ?>
                        </p>
                    <?php endif; ?>
                </div>
            </article>
        <?php endforeach; ?>

        <!-- Contrôles de navigation -->
        <button class="hero__control hero__control--prev" aria-label="Diapositive précédente">
            <svg class="hero__control-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" aria-hidden="true"
                focusable="false">
                <path fill="none" stroke="currentColor" stroke-width="2" d="M15 6l-6 6 6 6" />
            </svg>
        </button>
        <button class="hero__control hero__control--next" aria-label="Diapositive suivante">
            <svg class="hero__control-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" aria-hidden="true"
                focusable="false">
                <path fill="none" stroke="currentColor" stroke-width="2" d="M9 6l6 6-6 6" />
            </svg>
        </button>

        <!-- Indicateurs de slide -->
        <div class="hero__indicators" role="tablist">
            <?php foreach ($slides as $index => $slide):
                $active_class = $index === 0 ? ' hero__indicator--active' : '';
                ?>
                <button class="hero__indicator<?= $active_class; ?>" role="tab"
                    aria-selected="<?= $index === 0 ? 'true' : 'false'; ?>" aria-controls="hero-slide-<?= $index; ?>"
                    aria-label="Afficher la diapositive <?= $index + 1; ?>">
                    <span class="screen-reader-text">Diapositive <?= $index + 1; ?></span>
                </button>
            <?php endforeach; ?>
        </div>
    </div>
</section>