<?php

use Carbon_Fields\Block;
use Carbon_Fields\Field;

function pyrene_register_hero_carousel_block_fields()
{
    Block::make(__('Carousel de la page d\'accueil', 'pyrene'))
        ->set_category('pyrene', __('Pyrene'), 'smiley')
        ->set_keywords(['hero', 'carousel'])
        ->add_fields([
            Field::make('complex', 'slides', __('Slides', 'pyrene'))
                ->add_fields([
                    Field::make('image', 'image', __('Image', 'pyrene')),
                    Field::make('text', 'intro', __('Introduction', 'pyrene')),
                    Field::make('text', 'title', __('Titre', 'pyrene')),
                    Field::make('text', 'subtitle', __('Sous-titre', 'pyrene')),
                    Field::make('text', 'first_button_text', __('Texte du bouton', 'pyrene')),
                    Field::make('text', 'first_button_url', __('URL du bouton', 'pyrene')),
                    Field::make('text', 'second_button_text', __('Texte du bouton secondaire', 'pyrene')),
                    Field::make('text', 'second_button_url', __('URL du bouton secondaire', 'pyrene')),
                    // Author credit of the image
                    Field::make('text', 'author_credit', __('Crédit de l\'image', 'pyrene'))
                        ->set_help_text(__('Crédit de l\'image, par exemple: "©Jc_MIlhet"', 'pyrene')),

                ])
                ->set_layout('tabbed-vertical')
                ->set_max(5)
        ])
        ->set_mode('preview')
        ->set_render_callback(function ($fields, $attributes, $inner_blocks) {
            include_once dirname(__FILE__) . '/render.php';
        });
}

add_action('carbon_fields_register_fields', 'pyrene_register_hero_carousel_block_fields');
