<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

// Get current post data
$post_id = $block->context['postId'] ?? get_the_ID();
$post = get_post($post_id);

if (!$post) {
    return;
}

// Get post meta
$title = get_the_title($post_id);
$categories = get_the_category($post_id);
$tags = get_the_tags($post_id);

// Get featured image
$image_id = get_post_thumbnail_id($post_id);
$image_url = wp_get_attachment_image_url($image_id, 'full');
$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true) ?: $title;

// Get next/previous links
$next_post = get_next_post();
$prev_post = get_previous_post();
?>

<section class="hero-article">
    <article class="hero-article__container">
        <div class="hero-article__image-container">
            <?php if ($image_url) : ?>
                <img class="hero-article__image"
                    src="<?php echo esc_url($image_url); ?>"
                    alt="<?php echo esc_attr($image_alt); ?>"
                    loading="eager">
            <?php endif; ?>
        </div>
        <div class="hero-article__content">
            <?php if (!empty($categories)) : ?>
                <div class="hero-article__infos">
                    <div class="hero-article__categories">
                        <?php foreach ($categories as $category) : ?>
                            <a href="<?php echo esc_url(get_category_link($category->term_id)); ?>" class="hero-article__category">
                                <?php echo esc_html($category->name); ?>
                            </a>
                        <?php endforeach; ?>
                    </div>
                    <div class="hero-article__date">
                        <span class="hero-article__date">
                            <?php echo esc_html(get_the_date('d.m.Y', $post_id)); ?>
                        </span>
                    </div>
                </div>

            <?php endif; ?>

            <h1 class="hero-article__title has-white-color"><?php echo esc_html($title); ?></h1>

            <?php if (!empty($tags)) : ?>
                <div class="hero-article__tags">
                    <?php foreach ($tags as $tag) : ?>
                        <a href="<?php echo esc_url(get_tag_link($tag->term_id)); ?>" class="hero-article__tag">
                            #<?php echo esc_html($tag->name); ?>
                        </a>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- Navigation entre articles -->
        <div class="hero-article__navigation">
            <?php if ($prev_post) : ?>
                <a href="<?php echo esc_url(get_permalink($prev_post->ID)); ?>" class="hero-article__nav hero-article__nav--prev" aria-label="Article précédent : <?php echo esc_attr($prev_post->post_title); ?>">
                    <svg class="hero-article__nav-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" aria-hidden="true"
                        focusable="false">
                        <path fill="none" stroke="currentColor" stroke-width="2" d="M15 6l-6 6 6 6" />
                    </svg>
                    <span class="hero-article__nav-title screen-reader-text"><?php echo esc_html($prev_post->post_title); ?></span>
                </a>
            <?php endif; ?>

            <?php if ($next_post) : ?>
                <a href="<?php echo esc_url(get_permalink($next_post->ID)); ?>" class="hero-article__nav hero-article__nav--next" aria-label="Article suivant : <?php echo esc_attr($next_post->post_title); ?>">
                    <svg class="hero-article__nav-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" aria-hidden="true"
                        focusable="false">
                        <path fill="none" stroke="currentColor" stroke-width="2" d="M9 6l6 6-6 6" />
                    </svg>
                    <span class="hero-article__nav-title screen-reader-text"><?php echo esc_html($next_post->post_title); ?></span>
                </a>
            <?php endif; ?>
        </div>
    </article>
</section>