<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

// Get carbon fields values
$title = $fields['title'] ?? __('ACTUS PYRÉNÉENNES', 'pyrene');
$footer_text = $fields['footer_text'] ?? '';
// TODO : Use slug here
$category_id = 6; // ID de la catégorie "ACTUS PYRÉNÉENNES" 
// $category_id = 16; // ID de la catégorie "ACTUS PYRÉNÉENNES" EN LOCAL
$background_image = $fields['background_image'] ?? '';
$background_image_url = wp_get_attachment_image_url($background_image, 'full');



$default_image = $fields['default_image'] ?? '';
$read_more_text = $fields['read_more_text'] ?? __('En savoir plus', 'pyrene');

// Enqueue script and style
wp_enqueue_script(
    'pyrene-calendar-news-js',
    get_template_directory_uri() . '/blocks/calendar-news/calendar-news.js',
    array(),
    filemtime(get_template_directory() . '/blocks/calendar-news/calendar-news.js'),
    true
);

wp_localize_script('pyrene-calendar-news-js', 'pyreneCalendarData', array(
    'ajaxurl' => admin_url('admin-ajax.php'),
    'nonce' => wp_create_nonce('pyrene_calendar_news_nonce'),
    'category_id' => $category_id,
    'default_image' => $default_image,
    'read_more_text' => $read_more_text,
));

// Get current date
$current_date = new DateTime();
$current_month = intval($current_date->format('m'));
$current_year = intval($current_date->format('Y'));
$current_day = intval($current_date->format('d'));

$start_date = date('Y-m-d', strtotime($current_year . '-' . $current_month . '-01'));
$last_day = date('t', strtotime($current_year . '-' . $current_month . '-01'));
$end_date = date('Y-m-d', strtotime($current_year . '-' . $current_month . '-' . $last_day));

// Get days with posts in current month
$days_with_posts = array();
if ($category_id > 0) {
    $args = array(
        'post_type' => 'post',
        'post_status' => 'publish',
        'cat' => $category_id,
        'meta_query' => array(
            array(
                'key' => '_event_date',
                'value' => array($start_date, $end_date),
                'compare' => 'BETWEEN',
                'type' => 'DATE'
            )
        ),
        'posts_per_page' => -1,
    );
    $query = new WP_Query($args);

    if (is_wp_error($query)) {
        error_log('WP_Query error: ' . $query->get_error_message());
    } else {
        error_log('WP_Query success: ' . $query->request);
    }

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $event_date = carbon_get_post_meta(get_the_ID(), 'event_date');
            if (!empty($event_date)) {
                $event_day = intval(date('j', strtotime($event_date)));
                if (!in_array($event_day, $days_with_posts)) {
                    $days_with_posts[] = $event_day;
                }
            }
        }
    }
    wp_reset_postdata();
}


// Get feature post for today
$feature_post = null;
$feature_post_id = 0;
$feature_post_title = '';
$feature_post_excerpt = '';
$feature_post_permalink = '';
$feature_post_image = '';
$feature_post_category = '';
$feature_image_credit = '';

$current_date_formatted = $current_year . '-' . sprintf('%02d', $current_month) . '-' . sprintf('%02d', $current_day);

if (in_array($current_day, $days_with_posts)) {
    $args = array(
        'post_type' => 'post',
        'post_status' => 'publish',
        'cat' => $category_id,
        'meta_query' => array(
            array(
                'key' => '_event_date',
                'value' => $current_date_formatted,
                'compare' => '=',
                'type' => 'DATE'
            )
        ),
        'posts_per_page' => 1,
    );
    $query = new WP_Query($args);

    if ($query->have_posts()) {
        $query->the_post();
        $feature_post_id = get_the_ID();
        $feature_post_title = get_the_title();
        $feature_post_excerpt = has_excerpt() ? get_the_excerpt() : wp_trim_words(get_the_content(), 30, '...');
        $feature_post_permalink = get_permalink();

        if (has_post_thumbnail()) {
            $feature_post_image = get_the_post_thumbnail_url(null, 'large');
        } elseif (!empty($default_image)) {
            $feature_post_image = $default_image;
        }

        $categories = get_the_category();
        if (!empty($categories)) {
            $feature_post_category = $categories[0]->name;
        }

        // Get image credit
        $image_id = get_post_thumbnail_id();
        if ($image_id) {
            $image_credit = get_post_meta($image_id, '_credit', true);
            if (!empty($image_credit)) {
                $feature_image_credit = $image_credit;
            } else {
                // Fallback to caption
                $image_post = get_post($image_id);
                if ($image_post && !empty($image_post->post_excerpt)) {
                    $feature_image_credit = $image_post->post_excerpt;
                }
            }
        }
    }
    wp_reset_postdata();
}

// Get month names in French
$month_names = array(
    1 => 'JANVIER',
    2 => 'FÉVRIER',
    3 => 'MARS',
    4 => 'AVRIL',
    5 => 'MAI',
    6 => 'JUIN',
    7 => 'JUILLET',
    8 => 'AOÛT',
    9 => 'SEPTEMBRE',
    10 => 'OCTOBRE',
    11 => 'NOVEMBRE',
    12 => 'DÉCEMBRE'
);

// Get the number of days in the current month
$days_in_month = cal_days_in_month(CAL_GREGORIAN, $current_month, $current_year);

// Unique ID for this instance
$block_id = 'calendar-news-' . uniqid();
?>

<section
    class="calendar-news"
    id="<?php echo esc_attr($block_id); ?>"
    data-month="<?php echo esc_attr($current_month); ?>"
    data-year="<?php echo esc_attr($current_year); ?>"
    <?php if (!empty($background_image_url)) : ?>
    style="background-image: url('<?php echo esc_url($background_image_url); ?>');"
    <?php endif; ?>>
    <div class="calendar-news__header">
        <h2 class="calendar-news__title"><?php echo esc_html($title); ?></h2>

        <div class="calendar-news__month-nav">
            <button type="button" class="calendar-news__nav-button calendar-news__nav-prev" aria-label="<?php esc_attr_e('Mois précédent', 'pyrene'); ?>">
                <span aria-hidden="true">&#10094;</span>
            </button>

            <p class="calendar-news__month-title" id="month-title-<?php echo esc_attr($block_id); ?>">
                <?php echo esc_html($month_names[$current_month]); ?>
            </p>

            <button type="button" class="calendar-news__nav-button calendar-news__nav-next" aria-label="<?php esc_attr_e('Mois suivant', 'pyrene'); ?>">
                <span aria-hidden="true">&#10095;</span>
            </button>
        </div>
    </div>

    <div class="calendar-news__calendar" aria-labelledby="month-title-<?php echo esc_attr($block_id); ?>">
        <div class="calendar-news__days" role="grid">
            <?php for ($day = 1; $day <= $days_in_month; $day++) :
                $has_post = in_array($day, $days_with_posts);
                $is_today = ($day === $current_day);
                $day_classes = 'calendar-news__day';

                if ($has_post) {
                    $day_classes .= ' calendar-news__day--has-post';
                }

                if ($is_today) {
                    $day_classes .= ' calendar-news__day--today';
                }

                $aria_label = sprintf(
                    __('%d %s', 'pyrene'),
                    $day,
                    $month_names[$current_month]
                );

                if ($has_post) {
                    $aria_label .= __(' - Contient des actualités', 'pyrene');
                }

                if ($is_today) {
                    $aria_label .= __(' - Aujourd\'hui', 'pyrene');
                }
            ?>
                <?php if ($has_post) : ?>
                    <button
                        type="button"
                        class="<?php echo esc_attr($day_classes); ?>"
                        data-day="<?php echo esc_attr($day); ?>"
                        aria-label="<?php echo esc_attr($aria_label); ?>"
                        <?php echo $is_today ? 'aria-current="date"' : ''; ?>>
                        <?php echo esc_html($day); ?>
                    </button>
                <?php else : ?>
                    <span
                        class="<?php echo esc_attr($day_classes); ?>"
                        aria-label="<?php echo esc_attr($aria_label); ?>"
                        <?php echo $is_today ? 'aria-current="date"' : ''; ?>>
                        <?php echo esc_html($day); ?>
                    </span>
                <?php endif; ?>
            <?php endfor; ?>
        </div>
    </div>

    <div class="calendar-news__content" id="calendar-news-content-<?php echo esc_attr($block_id); ?>" aria-live="polite">
        <?php if ($feature_post_id > 0) : ?>
            <article class="calendar-news__article">
                <div class="calendar-news__image-container">
                    <?php if (!empty($feature_post_image)) : ?>
                        <img
                            src="<?php echo esc_url($feature_post_image); ?>"
                            alt="<?php echo esc_attr($feature_post_title); ?>"
                            class="calendar-news__image">
                    <?php endif; ?>
                </div>

                <div class="calendar-news__article-content">
                    <?php if (!empty($feature_post_category)) : ?>
                        <div class="calendar-news__category">
                            <span class="calendar-news__category-label"><?php echo esc_html($feature_post_category); ?></span>
                        </div>
                    <?php endif; ?>

                    <h3 class="calendar-news__article-title">
                        <?php echo esc_html($feature_post_title); ?>
                    </h3>

                    <div class="calendar-news__article-excerpt">
                        <?php echo wpautop(esc_html($feature_post_excerpt)); ?>
                    </div>

                    <div class="calendar-news__article-action">
                        <a href="<?php echo esc_url($feature_post_permalink); ?>" class="calendar-news__button">
                            <?php echo esc_html($read_more_text); ?>
                        </a>
                    </div>
                </div>
            </article>

            <?php if (!empty($feature_image_credit)) : ?>
                <div class="calendar-news__image-credit">
                    <?php echo esc_html($feature_image_credit); ?>
                </div>
            <?php endif; ?>
        <?php else : ?>
            <div class="calendar-news__no-content">
                <p><?php _e('Aucune actualité pour aujourd\'hui.', 'pyrene'); ?></p>
            </div>
        <?php endif; ?>
    </div>

    <?php if (!empty($footer_text)) : ?>
        <div class="calendar-news__footer">
            <p class="calendar-news__footer-text"><?php echo esc_html($footer_text); ?></p>
        </div>
    <?php endif; ?>
</section>