<?php

use Carbon_Fields\Block;
use Carbon_Fields\Field;

function pyrene_register_calendar_news_block_fields()
{
    Block::make(__('Calendrier d\'actualités', 'pyrene'))
        ->add_fields([
            Field::make('image', 'background_image', __('Image de fond', 'pyrene'))
                ->set_help_text(__('Image de fond du bloc calendrier', 'pyrene')),
            Field::make('text', 'title', __('Titre du bloc', 'pyrene'))
                ->set_default_value(__('ACTUS PYRÉNÉENNES', 'pyrene')),
            Field::make('text', 'footer_text', __('Texte de bas de bloc', 'pyrene'))
                ->set_help_text(__('Texte libre affiché en bas du bloc', 'pyrene')),
            Field::make('text', 'default_image', __('Image par défaut', 'pyrene'))
                ->set_help_text(__('URL de l\'image à afficher si un article n\'a pas d\'image mise en avant', 'pyrene')),
            Field::make('text', 'read_more_text', __('Texte du bouton "En savoir plus"', 'pyrene'))
                ->set_default_value(__('En savoir plus', 'pyrene')),
        ])
        ->set_mode('preview')
        ->set_render_callback(function ($fields, $attributes, $inner_blocks) {
            include_once dirname(__FILE__) . '/render.php';
        });
}

add_action('carbon_fields_register_fields', 'pyrene_register_calendar_news_block_fields');
