// search.js
document.addEventListener("DOMContentLoaded", function () {
  // Sélectionner les éléments
  const searchLink = document.querySelector(
    '.wp-block-navigation-item__content[href="#search"]'
  );
  const searchForm = document.querySelector(".wp-block-search");
  const searchInput = document.querySelector(".wp-block-search__input");

  if (!searchLink || !searchForm) return;

  // Gérer le clic sur le lien "Recherche"
  searchLink.addEventListener("click", function (e) {
    e.preventDefault();
    e.stopPropagation(); // Empêcher la propagation du clic
    searchForm.classList.add("is-active");

    // Focus sur l'input après une courte transition
    setTimeout(() => {
      searchInput.focus();
    }, 200);
  });

  // Fermer la recherche quand on clique ailleurs
  // Utilisation d'un délai pour éviter le déclenchement immédiat
  setTimeout(() => {
    document.addEventListener("click", function (e) {
      // Vérifier que le clic n'est ni sur le formulaire ni sur le lien
      if (
        searchForm.classList.contains("is-active") &&
        !searchForm.contains(e.target) &&
        e.target !== searchLink &&
        !searchLink.contains(e.target)
      ) {
        searchForm.classList.remove("is-active");
      }
    });
  }, 100);

  // Fermer avec la touche Escape
  document.addEventListener("keydown", function (e) {
    if (e.key === "Escape" && searchForm.classList.contains("is-active")) {
      searchForm.classList.remove("is-active");
    }
  });

  // Petite amélioration: si le formulaire est soumis avec un champ vide, on ferme sans soumettre
  searchForm.addEventListener("submit", function (e) {
    if (searchInput.value.trim() === "") {
      e.preventDefault();
      searchForm.classList.remove("is-active");
    }
  });

  // Position correcte du formulaire
  function positionSearchForm() {
    if (window.innerWidth > 768) {
      const linkRect = searchLink.getBoundingClientRect();

      const top = linkRect.bottom;
      const left = linkRect.left - 250;
      searchForm.style.top = `${top}px`;
      searchForm.style.left = `${left}px`;
      searchForm.style.right = "auto";
    } else {
      searchForm.style.top = "30%";
      searchForm.style.left = "0";
      searchForm.style.right = "0";
    }
  }

  // Positionner au chargement et au redimensionnement
  positionSearchForm();
  window.addEventListener("resize", positionSearchForm);
});
