document.addEventListener('DOMContentLoaded', function() {
    const banner = document.getElementById('cookie-consent-banner');
    if (!banner) return;

    const acceptButton = banner.querySelector('[data-action="accept"]');
    const refuseButton = banner.querySelector('[data-action="refuse"]');
    
    function setCookie(value) {
        const expiryDate = new Date();
        expiryDate.setMonth(expiryDate.getMonth() + 6);
        
        document.cookie = `analytics_consent=${value}; expires=${expiryDate.toUTCString()}; path=/; SameSite=Strict; Secure`;
    }

    function initAnalytics() {
        const script = document.createElement('script');
        script.async = true;
        script.src = 'https://www.googletagmanager.com/gtag/js?id=G-QHJX6KH595';
        document.head.appendChild(script);

        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', 'G-QHJX6KH595', {
            'anonymize_ip': true,
            'allow_ad_personalization_signals': false
        });
    }

    function handleCookieConsent(consent) {
        setCookie(consent);
        
        if (consent === 'accepted') {
            initAnalytics();
        }
        
        banner.style.display = 'none';
    }

    if (acceptButton) {
        acceptButton.addEventListener('click', () => handleCookieConsent('accepted'));
    }
    
    if (refuseButton) {
        refuseButton.addEventListener('click', () => handleCookieConsent('refused'));
    }

    // Vérifier l'état existant au chargement
    const existingConsent = document.cookie.match('(^|;)\\s*analytics_consent\\s*=\\s*([^;]*)');
    if (existingConsent && existingConsent[2] === 'accepted') {
        initAnalytics();
        banner.style.display = 'none';
    }
});