/**
 * Hero Carousel JavaScript
 * Gère la fonctionnalité du carousel sur la page d'accueil
 */

document.addEventListener('DOMContentLoaded', function() {
    // Sélectionner les éléments du carousel
    const carousel = document.querySelector('.hero__carousel');
    
    // Si le carousel n'existe pas sur cette page, ne rien faire
    if (!carousel) return;
    
    const slides = carousel.querySelectorAll('.hero__slide');
    const prevButton = carousel.querySelector('.hero__control--prev');
    const nextButton = carousel.querySelector('.hero__control--next');
    const indicators = carousel.querySelectorAll('.hero__indicator');
    
    let currentIndex = 0;
    const slideCount = slides.length;
    
    // Fonction pour afficher un slide spécifique
    function showSlide(index) {
      // S'assurer que l'index est valide
      if (index < 0) index = slideCount - 1;
      if (index >= slideCount) index = 0;
      
      // Mettre à jour l'index courant
      currentIndex = index;
      
      // Mettre à jour les classes et attributs ARIA pour tous les slides
      slides.forEach((slide, i) => {
        const isActive = i === currentIndex;
        slide.classList.toggle('hero__slide--active', isActive);
        slide.setAttribute('aria-hidden', isActive ? 'false' : 'true');
      });
      
      // Mettre à jour les indicateurs
      indicators.forEach((indicator, i) => {
        const isActive = i === currentIndex;
        indicator.classList.toggle('hero__indicator--active', isActive);
        indicator.setAttribute('aria-selected', isActive ? 'true' : 'false');
      });
    }
    
    // Gestionnaire d'événement pour le bouton précédent
    prevButton.addEventListener('click', () => {
      showSlide(currentIndex - 1);
    });
    
    // Gestionnaire d'événement pour le bouton suivant
    nextButton.addEventListener('click', () => {
      showSlide(currentIndex + 1);
    });
    
    // Gestionnaire d'événement pour les indicateurs
    indicators.forEach((indicator, index) => {
      indicator.addEventListener('click', () => {
        showSlide(index);
      });
    });
    
    // Gestionnaire d'événement pour les touches clavier
    carousel.addEventListener('keydown', (e) => {
      switch (e.key) {
        case 'ArrowLeft':
          showSlide(currentIndex - 1);
          break;
        case 'ArrowRight':
          showSlide(currentIndex + 1);
          break;
        case 'Home':
          showSlide(0);
          break;
        case 'End':
          showSlide(slideCount - 1);
          break;
      }
    });
    
    // Support tactile basique
    let touchStartX = 0;
    let touchEndX = 0;
    
    carousel.addEventListener('touchstart', (e) => {
      touchStartX = e.changedTouches[0].screenX;
    });
    
    carousel.addEventListener('touchend', (e) => {
      touchEndX = e.changedTouches[0].screenX;
      handleSwipe();
    });
    
    function handleSwipe() {
      const swipeThreshold = 50; // Seuil minimum pour considérer comme un swipe
      
      if (touchEndX < touchStartX - swipeThreshold) {
        // Swipe vers la gauche
        showSlide(currentIndex + 1);
      }
      
      if (touchEndX > touchStartX + swipeThreshold) {
        // Swipe vers la droite
        showSlide(currentIndex - 1);
      }
    }
  });